﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Xml.Linq;

namespace Kolekcja2Xml
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        class Osoba
        {
            public int Id;
            public string Imię, Nazwisko;
            public int NumerTelefonu;
            public int Wiek;
        }

        List<Osoba> listaOsob = new List<Osoba> 
        { 
            new Osoba { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", 
                        NumerTelefonu = 7272024, Wiek = 37 }, 
            new Osoba { Id = 2, Imię = "Katarzyna", Nazwisko = "Matulewska", 
                        NumerTelefonu = 7272020, Wiek = 38 },
            new Osoba { Id = 3, Imię = "Karolina", Nazwisko = "Matulewska", 
                        NumerTelefonu = 7272021, Wiek = 9 }, 
            new Osoba { Id = 4, Imię = "Bartosz", Nazwisko = "Matulewski", 
                        NumerTelefonu = 7272022, Wiek = 4 } 
        };

        private void button1_Click(object sender, EventArgs e)
        {
            XDocument xml = new XDocument(
                new XDeclaration("1.0","utf-8","yes"),
                new XElement("ListaOsob",
                    from osoba in listaOsob
                    orderby osoba.Wiek
                    select new XElement("Osoba",
                        new XAttribute("Id", osoba.Id),
                        new XElement("Imię", osoba.Imię),
                        new XElement("Nazwisko", osoba.Nazwisko),
                        new XElement("NumerTelefonu", osoba.NumerTelefonu),
                        new XElement("Wiek", osoba.Wiek)
                        )
                )
            );

            xml.Save(@"\Temp\Telefony.xml");      
        }
    }
}